<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;
    protected $fillable = array('title', 'parent_id', 'type');

    public function descriptions()
    {
        return $this->hasMany('App\Models\ServiceDescription');
    }

    public function shildren()
    {
        return $this->hasMany('App\Models\Service', 'parent_id');
    }

    public function parent()
    {
        return $this->belongsTo('App\Models\Service', 'parent_id');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order', 'service_id');
    }

    public function subServiceOrders()
    {
        return $this->hasMany('App\Models\Order', 'sub_service_id');
    }

}